local zm = SCREEN_HEIGHT / 1080; -- assets are made for 1080p
local bt = 60 / 128; -- fuck it, length of a beat

-- defining some transitions that I will reuse

local initFunc = function(self)
    self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y)
        :effectclock("beat"):diffusealpha(0):basezoom(zm);
end

local inFade = function(self)
    self:decelerate(bt)
        :diffusealpha(1);
end

local outFade = function(self)
    self:accelerate(bt)
        :diffusealpha(0);
end

local inZoom = function(self, zoom)
    self:zoom(zoom)
        :decelerate(bt)
        :zoom(1)
        :diffusealpha(1);
end

local outZoom = function(self, zoom)
    self:accelerate(bt)
        :zoom(zoom)
        :diffusealpha(0);
end

local inBelow = function(self, y)
    self:y((y + 0.5) * SCREEN_HEIGHT)
        :decelerate(bt)
        :y(y * SCREEN_HEIGHT)
        :diffusealpha(1);
end

local outBelow = function(self, y)
    self:accelerate(bt)
        :y((y + 0.5) * SCREEN_HEIGHT)
        :diffusealpha(0);
end

local inAbove = function(self, y)
    self:y((y - 0.5) * SCREEN_HEIGHT)
        :decelerate(bt)
        :y(y * SCREEN_HEIGHT)
        :diffusealpha(1);
end

local outAbove = function(self, y)
    self:accelerate(bt)
        :y((y - 0.5) * SCREEN_HEIGHT)
        :diffusealpha(0);
end

local inCount = function(self)
    self:zoom(2)
        :sleep(0.75);
    self:decelerate(0.25)
        :zoom(1)
        :diffusealpha(1);
    self:glowramp(color(1, 1, 1, 0), color(1, 1, 1, 1));
    self:queuecommand("StopGlow");
end


return Def.ActorFrame{
    Def.Actor{
        Name="hibernator",
        OnCommand=function(self)
            self:sleep(9e9);
            --SCREENMAN:SystemMessage("default.lua has been loaded");
        end
    }, --[[ this next one just prints the current beat over and over.
    Def.BitmapText{
        Font="Common Normal",
        OnCommand=function(self)
            self:xy(SCREEN_CENTER_X, 0.1*SCREEN_CENTER_Y):effectclock("beat"):playcommand("SetTime");
        end,
        SetTimeCommand=function(self)
            self:settext(self:GetSecsIntoEffect());
            self:sleep(0.1);
            self:queuecommand("SetTime");
        end,
        Text="Test"
    }, --]]
    Def.ActorFrame{
        Name="PaddyMcTiltface",
        FOV=45,
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            local defY = 0.7;

            self:rotationx(-70);
            -- with 2
            self:zoom(1.1);
            self:sleep(16.5 * bt);  -- b16.5
            inBelow(self, defY);    -- b17.5
            self:sleep(6.5 * bt);   -- b24
            outBelow(self, defY);   -- b25

            self:zoom(1);
            -- with 5
            self:sleep(42.5 * bt);  -- b67.5
            inBelow(self, defY);    -- b68.5
            self:sleep(6.5 * bt);   -- b74
            outBelow(self, defY);   -- b75

            -- with 9
            self:sleep(52.5 * bt);
            inBelow(self, defY);
            self:sleep(9.5 * bt);
            outBelow(self, defY);
            
            -- with 11
            self:sleep(23.5 * bt);
            inBelow(self, defY);
            self:sleep(25.5 * bt);  -- b192
            outBelow(self, defY);
        end,
        Def.Sprite{
            Texture="pad_big.png",
            --Place your Init/OnCommands here.
            InitCommand=function(self)
                self:diffusealpha(1);
                self:y(0);
            end
        },
        Def.Sprite{
            Texture="pad_light_0.png",
            InitCommand=function(self)
                self:diffusealpha(0);
                self:effectclock("beat");
            end,
            OnCommand=function(self)
                local panel = 192;
                self:xy(panel, 0);
                -- Step Right
                self:sleep(69 * bt);
                for i = 1, 6 do
                    self:playcommand("Pulse");
                end; -- b75
                self:queuecommand("On2");
            end,
            On2Command=function(self)
                self:sleep((170 - 75) * bt);
                local panel = 192;

                self:xy(-panel, 0);
                self:playcommand("Long");
                self:xy(0, panel);
                self:playcommand("Long");
                self:xy(0, -panel);
                self:playcommand("Long");
                self:xy(-panel, 0);
                self:playcommand("Long");
                self:sleep(4 * bt);
                self:xy(0, panel);
                self:playcommand("Long");
                self:xy(0, panel);
                self:playcommand("Long");
                self:xy(0, panel);
                self:playcommand("Long");
                self:xy(0, panel);
                self:playcommand("Long");
            end,
            PulseCommand=function(self)
                self:diffusealpha(1);
                self:sleep(0.05 * bt);
                self:linear(0.9 * bt)
                    :diffusealpha(0);
                self:sleep(0.05 * bt);
            end,
            LongCommand=function(self)
                self:diffusealpha(1);
                self:sleep(1.5 * bt);
                self:linear(0.45 * bt)
                    :diffusealpha(0);
                self:sleep(0.05 * bt);
            end
        },
        Def.Sprite{
            Texture="pad_light_1.png",
            InitCommand=function(self)
                self:diffusealpha(0);
                self:effectclock("beat");
            end,
            OnCommand=function(self)
                local panel = 192;
                -- Alternate Steps
                self:sleep(171 * bt);

                self:xy(0, -panel);
                self:playcommand("Long");
                self:xy(panel, 0);
                self:playcommand("Long");
                self:xy(0, panel);
                self:playcommand("Long");
                self:sleep(6 * bt);

                self:xy(0, -panel);
                self:playcommand("Long");
                self:xy(0, -panel);
                self:playcommand("Long");
                self:xy(0, -panel);
                self:playcommand("Long");
            end,
            LongCommand=function(self)
                self:diffusealpha(1);
                self:sleep(1.5 * bt);
                self:linear(0.45 * bt)
                    :diffusealpha(0);
                self:sleep(0.05 * bt);
            end
        },
        Def.Sprite{
            Texture="pad_light_2.png",
            InitCommand=function(self)
                self:diffusealpha(0);
                self:effectclock("beat");
            end,
            OnCommand=function(self)
                self:sleep(132 * bt);
                for i = 1, 8 do
                    self:queuecommand("Pulse");
                end;
                
            end,
            PulseCommand=function(self)
                self:diffusealpha(1);
                self:sleep(0.05 * bt);
                self:linear(0.9 * bt)
                    :diffusealpha(0);
                self:sleep(0.05 * bt);
            end
        },
        Def.Sprite{
            Texture="pad_no_center.png",
            InitCommand=function(self)
                self:diffusealpha(0);
                self:effectclock("beat");
            end,
            OnCommand=function(self)
                self:sleep(164 * bt);
                for i = 1, 4 do
                    self:playcommand("Pulse");
                end;
                self:diffusealpha(1);
                self:sleep(8 * bt);
            end,
            PulseCommand=function(self)
                self:diffusealpha(1);
                self:sleep(0.5 * bt);
                self:linear(0.45 * bt)
                    :diffusealpha(0);
                self:sleep(0.05 * bt);
            end
        },
    },
    Def.Sprite{
        Texture="1a.png",
        --Place your Init/OnCommands here.
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.4 * SCREEN_HEIGHT);
            
            self:sleep(3 * bt);
            
            inZoom(self, 2);
            
            self:sleep(11 * bt);

            outZoom(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="1b.png",
        --Place your Init/OnCommands here.
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.55 * SCREEN_HEIGHT);
            
            self:sleep(7 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(7 * bt);

            outZoom(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="2.png",
        --Place your Init/OnCommands here.
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)

            self:sleep(16 * bt);
            
            inBelow(self, 0.25);
            
            self:sleep(7 * bt);

            outBelow(self, 0.25);
        end
    },
    Def.Sprite{
        Texture="3a.png",
        --Place your Init/OnCommands here.
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)

            self:sleep(24 * bt);
            
            inBelow(self, 0.35);

            self:bob()
                :effectmagnitude(0, 0.02 * SCREEN_HEIGHT, 0);
            
            self:sleep(4 * bt);

            self:queuecommand("StopBob"); -- effects cannot be tweened.

            self:sleep(15 * bt);

            outZoom(self, 0.5);
        end,
        StopBobCommand=function(self)
            self:stopeffect();
        end
    },
    Def.Sprite{
        Texture="3b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.55 * SCREEN_HEIGHT);
            
            self:sleep(33 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(10 * bt);

            outZoom(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="3c.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.7 * SCREEN_HEIGHT);
            
            self:sleep(39 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(4 * bt);

            outZoom(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="4a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(45 * bt);
            
            inAbove(self, 0.7);
            
            self:sleep(4 * bt);

            outAbove(self, 0.7);
        end
    },
    Def.Sprite{
        Texture="4b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(50 * bt):y(0.3 * SCREEN_HEIGHT);
            
            inFade(self);
            
            self:sleep(6 * bt);

            outZoom(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="4c.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.3 * SCREEN_HEIGHT);
            self:sleep(58 * bt);
            
            inCount(self);
            
            self:sleep(4 * bt);

            outFade(self, 1);
        end,
        StopGlowCommand=function(self)
            self:stopeffect();
        end
    },
    Def.Sprite{
        Texture="4d.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.3 * SCREEN_HEIGHT);
            self:sleep(59 * bt);
            
            inCount(self);
            
            self:sleep(3 * bt);

            outFade(self, 1);
        end,
        StopGlowCommand=function(self)
            self:stopeffect();
        end
    },
    Def.Sprite{
        Texture="4e.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.3 * SCREEN_HEIGHT);
            self:sleep(60 * bt);
            
            inCount(self);
            
            self:sleep(2 * bt);

            outFade(self, 1);
        end,
        StopGlowCommand=function(self)
            self:stopeffect();
        end
    },
    Def.Sprite{
        Texture="4f.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.3 * SCREEN_HEIGHT);
            self:sleep(61 * bt);
            
            inCount(self);
            
            self:sleep(1 * bt);

            outFade(self, 1);
        end,
        StopGlowCommand=function(self)
            self:stopeffect();
        end
    },
    Def.Sprite{
        Texture="5a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(64 * bt);
            
            inBelow(self, 0.3);
            
            self:sleep(10 * bt);

            outBelow(self, 0.3);
        end
    },
    Def.Sprite{
        Texture="5b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(68 * bt);
            self:y(0.45 * SCREEN_HEIGHT);
            
            inZoom(self, 0.5);
            
            self:sleep(6 * bt);

            outBelow(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="6a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.45 * SCREEN_HEIGHT);
            self:sleep(75 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(3 * bt);

            self:linear(4 * bt)
                :diffusealpha(0);
        end
    },
    Def.Sprite{
        Texture="6b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.55 * SCREEN_HEIGHT);
            self:sleep(78 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(3 * bt);

            self:linear(4 * bt)
                :diffusealpha(0);
        end
    },
    Def.Sprite{
        Texture="7a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.3 * SCREEN_HEIGHT);
            self:sleep(102 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(8 * bt);

            outZoom(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="7b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(104 * bt);
            
            inBelow(self, 0.6);
            
            self:sleep(6 * bt);

            outZoom(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="8a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(111 * bt);
            
            inBelow(self, 0.4);
            
            self:sleep(5 * bt);

            self:linear(2 * bt)
                :diffusealpha(0);
        end
    },
    Def.Sprite{
        Texture="8b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(117 * bt);
            
            inBelow(self, 0.6);
            
            self:sleep(7 * bt);

            self:linear(2 * bt)
                :diffusealpha(0);
        end
    },
    Def.Sprite{
        Texture="9a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(128 * bt);
            
            inBelow(self, 0.3);
            
            self:sleep(10 * bt);

            outBelow(self, 0.3);
        end
    },
    Def.Sprite{
        Texture="9b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(132 * bt);
            self:y(0.45 * SCREEN_HEIGHT);
            
            inZoom(self, 0.5);
            
            self:sleep(6 * bt);

            outBelow(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="10a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.45 * SCREEN_HEIGHT);
            self:sleep(140 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(3 * bt);

            self:linear(4 * bt)
                :diffusealpha(0);
        end
    },
    Def.Sprite{
        Texture="10b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:y(0.55 * SCREEN_HEIGHT);
            self:sleep(144 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(3 * bt);

            self:linear(4 * bt)
                :diffusealpha(0);
        end
    },
    Def.Sprite{
        Texture="11a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(162 * bt);
            
            inBelow(self, 0.3);
            
            self:sleep(15 * bt);

            outAbove(self, 0.3);
        end
    },
    Def.Sprite{
        Texture="11b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(168 * bt);
            self:y(0.45 * SCREEN_HEIGHT);
            
            inZoom(self, 0.5);
            
            self:sleep(9 * bt);

            outAbove(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="12a.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(178 * bt);
            
            inAbove(self, 0.3);
            
            self:sleep(10 * bt);

            outBelow(self, 0.3);
        end
    },
    Def.Sprite{
        Texture="12b.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(182 * bt);
            self:y(0.45 * SCREEN_HEIGHT);
            
            inZoom(self, 0.5);
            
            self:sleep(6 * bt);

            outBelow(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="13.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(203 * bt);
            
            inZoom(self, 0.5);
            
            self:sleep(6 * bt);

            outZoom(self, 0.5);
        end
    },
    Def.Sprite{
        Texture="end.png",
        InitCommand=function(self)
            initFunc(self);
        end,
        OnCommand=function(self)
            self:sleep(227 * bt);
            
            inZoom(self, 2);

            self:sleep(8 * bt);
        end
    },
}