if not ((GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:GetCurrentSteps(PLAYER_1):GetDifficulty()=="Difficulty_Challenge") or
			(GAMESTATE:IsPlayerEnabled(PLAYER_2) and GAMESTATE:GetCurrentSteps(PLAYER_2):GetDifficulty()=="Difficulty_Challenge")) then
	return Def.ActorFrame{}
end

local songName= GAMESTATE:GetCurrentSong():GetSongDir()

local function iris_mod_internal(str, pn)
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
	--GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function iris_mod(str)
	for i=1,2 do
		if _G['iris_diffP'..i] == 4 then
			iris_mod_internal(str, 'PlayerNumber_P' .. i)
		end
	end
end

local function get_speed_from_poptions(player_number)
	if GAMESTATE:IsPlayerEnabled(player_number) then
		local poptionsray= GAMESTATE:GetPlayerState(player_number):GetPlayerOptionsArray("ModsLevel_Song")
		local speed= nil
		local mode= nil
		for i, el in ipairs(poptionsray) do
			local fel= el:sub(1, 1)
			local lel= el:sub(-1)
			if fel == "m" or fel == "C" then
				speed= tonumber(el:sub(2))
				mode= fel
			elseif lel == "x" then
				speed= tonumber(el:sub(1, -2))
				mode= lel
			end
			if speed and mode then
				break
			end
		end
	end
	if not speed or not mode then
		speed= 2
		mode= "x"
	end
	return { speed= speed, mode= mode }
end

local function set_player_speed(player_number, speed_info)
	if not GAMESTATE:IsPlayerEnabled(player_number) then return end
	local mode_functions= {
		x= function(speed)
				 iris_mod_internal(("*1000 %.2f"):format(speed).."x", player_number)
			 end,
		C= function(speed)
				 iris_mod_internal("*1000 C"..("%.0f"):format(speed), player_number)
			 end,
		m= function(speed)
				 local max_bpm= GAMESTATE:GetCurrentSteps(pn):GetDisplayBpms()[2]
				 local real_speed= (speed / max_bpm)
				 -- Setting an mmod while on ScreenGameplay doesn't actually work, due to the way mmods are implemented in the engine. So set the equivalent xmod
				 iris_mod_internal(("*1000 %.2f"):format(real_speed).."x", player_number)
			 end
	}
	mode_functions[speed_info.mode](speed_info.speed)
end

local function iris_init()
	fgcurcommand = 0;
	checked = false;
	
	iris_diffP1 = -1;
	iris_diffP2 = -1;
	
	if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
		iris_diffP1 = Difficulty:Reverse()[GAMESTATE:GetCurrentSteps(PLAYER_1):GetDifficulty()]
	end
	if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
		iris_diffP2 = Difficulty:Reverse()[GAMESTATE:GetCurrentSteps(PLAYER_2):GetDifficulty()]
	end
	
	iris_speedmodP1 = get_speed_from_poptions(PLAYER_1)
	iris_speedmodP2 = get_speed_from_poptions(PLAYER_2)
	
	iris_centeredwait = 0;
	iris_altmodwait = 0;
	
	--lua course :D	/ timed mod management	
	curmod = 1;
	--{beat,mod,player}
	mods = {

		{7-.1,'*10 no mini, *10 overhead, *10 no flip'},

		{48-.1,'*2 200 distant'},
		{50-.1,'*10 no distant'},
		{51-.1,'*2 200 distant'},
		{51.5,'*10000 300 beat'},
		{53-.1,'*10 no distant'},
		{53.5,'*10000 no beat'},

		{54-.1,'*2 200 hallway'},
		{56-.1,'*10 no hallway'},
		{57-.1,'*2 200 hallway'},
		{57.5,'*10000 300 beat'},
		{59-.1,'*10 no hallway'},
		{59.5,'*10000 no beat'},

		{60-.1,'*2 200 distant'},
		{62-.1,'*10 no distant'},
		{63-.1,'*2 200 distant'},
		{63.5,'*10000 300 beat'},
		{65-.1,'*10 no distant'},
		{65.5,'*10000 no beat'},

		{66,'*0.5 50 tornado'},
		{69,'*0.5 no tornado'},

		{72-.1,'*2 200 distant'},
		{74-.1,'*10 no distant'},
		{75-.1,'*2 200 distant'},
		{75.5,'*10000 300 beat'},
		{77-.1,'*10 no distant'},
		{77.5,'*10000 no beat'},

		{78-.1,'*2 200 hallway'},
		{80-.1,'*10 no hallway'},
		{81-.1,'*2 200 hallway'},
		{81.5,'*10000 300 beat'},
		{83-.1,'*10 no hallway'},
		{83.5,'*10000 no beat'},

		{84-.1,'*2 200 distant'},
		{86-.1,'*10 no distant'},
		{87-.1,'*2 200 distant'},
		{87.5,'*10000 300 beat'},
		{89-.1,'*10 no distant'},
		{89.5,'*10000 no beat'},

		{90,'*0.5 50 tornado'},
		{93,'*0.5 no tornado'},
		{93.5,'*10000 300 beat'},
		{95.5,'*10000 no beat'},

		{96-.1,'*10 80 mini'},
		{96.5-.1,'*10 no mini'},
		{97.5-.1,'*10 invert'},
		{98.5-.1,'*10 no invert'},
		{99.5-.05,'*100 15 flip'},
		{100.0-.05,'*100 30 flip'},
		{100.5-.05,'*100 15 flip'},
		{101.0-.05,'*100 no flip'},
		{102-.1,'*10 80 mini'},
		{102.5-.1,'*10 no mini'},
		{103.5-.1,'*10 invert'},
		{104.5-.1,'*10 no invert'},
		{105.5-.05,'*100 15 flip'},
		{106.0-.05,'*100 30 flip'},
		{106.5-.05,'*100 15 flip'},
		{107.0-.05,'*100 no flip'},
		{108-.1,'*10 80 mini'},
		{108.5-.1,'*10 no mini'},
		{109.5-.1,'*10 invert'},
		{110.5-.1,'*10 no invert'},
		{111.5-.05,'*100 15 flip'},
		{112.0-.05,'*100 30 flip'},
		{112.5-.05,'*100 15 flip'},
		{113.0-.05,'*100 no flip'},

		{114,'*0.5 50 tornado'},
		{117,'*0.5 no tornado'},

		{120-.1,'*10 80 mini'},
		{120.5-.1,'*10 no mini'},
		{121.5-.1,'*10 invert'},
		{122.5-.1,'*10 no invert'},
		{123.5-.05,'*100 15 flip'},
		{124.0-.05,'*100 30 flip'},
		{124.5-.05,'*100 15 flip'},
		{125.0-.05,'*100 no flip'},
		{126-.1,'*10 80 mini'},
		{126.5-.1,'*10 no mini'},
		{127.5-.1,'*10 invert'},
		{128.5-.1,'*10 no invert'},
		{129.5-.05,'*100 15 flip'},
		{130.0-.05,'*100 30 flip'},
		{130.5-.05,'*100 15 flip'},
		{131.0-.05,'*100 no flip'},
		{132-.1,'*10 80 mini'},
		{132.5-.1,'*10 no mini'},
		{133.5-.1,'*10 invert'},
		{134.5-.1,'*10 no invert'},
		{135.5-.05,'*100 15 flip'},
		{136.0-.05,'*100 30 flip'},
		{136.5-.05,'*100 15 flip'},
		{137.0-.05,'*100 no flip'},

		{140.5,'*1.5 centered, *1.5 split, 1.5x'},

		{145-.1,'*10 invert'},
		{146.5-.1,'*10 no invert'},
		{157-.1,'*10 invert'},
		{158.5-.1,'*10 no invert'},

		{160,'*1 tornado'},
		{164,'*1 no tornado'},

		{168,'*10 no hallway'},

		{169-.1,'*10 invert'},
		{170.5-.1,'*10 no invert'},
		{181-.1,'*10 invert'},
		{182.5-.1,'*10 no invert, *10 no centered, *10 no split'},

		{257,'*1000 200 mini, *1000 tornado'},
		{258,'*0.5 no mini, *0.5 150 wave'},
		{270,'*0.4 no tornado, *0.6 no wave, *0.5 no sudden'},

		{280.5,'*1000 250 beat'},
		{281,'*0.1 drunk, *0.05 tipsy'},
		{281.5,'*1000 no beat'},

		{305-.1,'*2 no drunk, *1 no tipsy'},

		{305-.1,'*3 200 distant'},
		{307-.1,'*15 no distant'},
		{308-.1,'*3 200 distant'},
		{308.5,'*10000 500 beat'},
		{310-.1,'*15 no distant'},
		{310.5,'*10000 no beat'},

		{311-.1,'*3 200 hallway'},
		{313-.1,'*15 no hallway'},
		{314-.1,'*3 200 hallway'},
		{314.5,'*10000 500 beat'},
		{316-.1,'*15 no hallway'},
		{316.5,'*10000 no beat'},

		{317-.1,'*3 200 distant'},
		{319-.1,'*15 no distant'},
		{320-.1,'*3 200 distant'},
		{320.5,'*10000 500 beat'},
		{322-.1,'*15 no distant'},
		{322.5,'*10000 no beat'},

		{323-.1,'*3 200 hallway'},
		{325-.1,'*15 no hallway'},
		{326-.1,'*3 200 hallway'},
		{326.5,'*10000 500 beat'},
		{328-.1,'*15 no hallway'},
		{328.5,'*10000 no beat'},

		{329-.1,'*10 120 mini'},
		{329.5-.1,'*10 no mini'},
		{330.5-.1,'*10 invert'},
		{331.5-.1,'*10 no invert'},
		{332.5-.05,'*100 25 flip'},
		{333.0-.05,'*100 50 flip'},
		{333.5-.05,'*100 25 flip'},
		{334.0-.05,'*100 no flip'},
		{335-.1,'*10 120 mini'},
		{335.5-.1,'*10 no mini'},
		{336.5-.1,'*10 invert'},
		{337.5-.1,'*10 no invert'},
		{338.5-.05,'*100 25 flip'},
		{339.0-.05,'*100 50 flip'},
		{339.5-.05,'*100 25 flip'},
		{340.0-.05,'*100 no flip'},
		{341-.1,'*10 120 mini'},
		{341.5-.1,'*10 no mini'},
		{342.5-.1,'*10 invert'},
		{343.5-.1,'*10 no invert'},
		{344.5-.05,'*100 25 flip'},
		{345.0-.05,'*100 50 flip'},
		{345.5-.05,'*100 25 flip'},
		{346.0-.05,'*100 no flip'},

		{347,'*4 314 dizzy, *1 100 drunk'},
		{349.5,'*40 no dizzy, *10 no drunk'},
		{350,'*4 -314 dizzy, *1 -100 drunk'},
		{352.5,'*40 no dizzy, *10 no drunk'},

		{353,'*0.166 50 flip'},
		{353,'*0.166 -50 tornado'},

		{363.5,'*1000 -100 hidden, *1000 -100 sudden, *1000 stealth, *1000 20 hiddenoffset, *1000 -20 suddenoffset'},
		{363.6,'*4 -200 hiddenoffset, *4 200 suddenoffset'},

	}

	iris_driven = 1;
	iris_driven_beat = 193;
	iris_driven_beat_init = 193;

	iris_driven_speed = 0.65;
	iris_driven_modspeed = 1.0;

	iris_drunk = 1;
	iris_drunk_amt = 0;
	iris_bumpy = 1;
	iris_bumpy_amt = 0;

	--SCREAMING GUMBALL / timed message broadcaster
	curmessage = 1;
	--{beat,message,ignoreIfAhead}
	messages = {
		{182.5,'CytusSpawn'},
		{193,'CytusBegin'},
		{257,'CytusEnd'},
	}
	
end

local function iris_update()

	if GAMESTATE:GetSongBeat()>=0.1 and not checked then
		
		P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
		P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
		
		screen = SCREENMAN:GetTopScreen()
		checked = true;
		
	end
	
	local beat = GAMESTATE:GetSongBeat()

	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		iris_mod(total_mod_str)
	end
	
	if beat>7 and fgcurcommand==0 then
		if P1 then P1:linear(0.1) P1:x(SCREEN_WIDTH*0.25) end
		if P2 then P2:linear(0.1) P2:x(SCREEN_WIDTH*0.75) end
		fgcurcommand = fgcurcommand+1;
	end
	
	if iris_centeredwait > 0 then
		iris_centeredwait = iris_centeredwait-0.02
	end
	if iris_altmodwait > 0 then
		iris_altmodwait = iris_altmodwait-0.02
	end
	
	if beat>iris_driven_beat_init and beat<257 and iris_centeredwait<=0 then
		add_mod('*'..iris_driven_modspeed..' 400 centered')
	end
	
	if beat>182.5 and fgcurcommand==1 then
		add_mod('*0.5 stealth')
		add_mod('*0.5 dark')
		fgcurcommand = fgcurcommand+1;
	end
	
	if beat>160 and beat<168 and iris_altmodwait<=0 then
		if iris_bumpy == 1 then
			add_mod('*10000 '..(iris_bumpy_amt)..' hallway')
		else
			add_mod('*10000 '..(iris_bumpy_amt*-1)..' hallway')
		end
		
		if beat<164 then
			iris_bumpy_amt = iris_bumpy_amt+4
		else
			iris_bumpy_amt = iris_bumpy_amt-4
		end
		
		iris_bumpy = iris_bumpy*-1;
		iris_altmodwait = 0.02;
	end
	
	if beat>182.5 and beat<191 and iris_altmodwait<=0 then
		if iris_drunk == 1 then
			add_mod('*10000 '..(iris_drunk_amt)..' drunk')
		else
			add_mod('*10000 '..(iris_drunk_amt*-1)..' drunk')
		end
		
		if beat<186.75 then
			iris_drunk_amt = iris_drunk_amt+5
		else
			iris_drunk_amt = iris_drunk_amt-5
			add_mod('*2 '..iris_driven_speed..'x')
			add_mod('*1 100 sudden')
			add_mod('*1 50 suddenoffset')
		end
		
		iris_drunk = iris_drunk*-1;
		iris_altmodwait = 0.02;
	end
	
	if beat>191 and fgcurcommand==2 then
		add_mod('*3 no stealth')
		add_mod('*3 no drunk')
		fgcurcommand = fgcurcommand+1;
	end
	
	if beat>iris_driven_beat and beat<257 then
		if iris_driven == 1 then
			add_mod('*1000 '..iris_driven_speed..'x')
			add_mod('*1000 no reverse')
			add_mod('*1000 no centered')
			iris_driven = iris_driven*-1
		else
			add_mod('*1000 '..iris_driven_speed..'x')
			add_mod('*1000 reverse')
			add_mod('*1000 no centered')
			iris_driven = iris_driven*-1
		end
		iris_driven_beat = iris_driven_beat+8;
		iris_centeredwait = 0.06
	end
	
	if beat>257 and fgcurcommand == 3 then
		set_player_speed(PLAYER_1, iris_speedmodP1)
		set_player_speed(PLAYER_2, iris_speedmodP2)
		add_mod('*1000 no reverse')
		add_mod('*1000 no centered')
		add_mod('*1000 no dark')
		fgcurcommand = fgcurcommand+1
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		add_mod(mods[curmod][2])
		curmod = curmod+1
	end

	execute_mods()
	
	--SCREAMING GUMBALL
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][3] and GAMESTATE:GetSongBeat()>=messages[curmessage][1]+5 then
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2])
			curmessage = curmessage+1;
		end
	end
end

return Def.ActorFrame{
	OnCommand= function(self)
							 iris_init()
							 self:SetUpdateFunction(iris_update)
						 end,
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},
	Def.Quad{
		OnCommand= cmd(diffuse,0,0,0,1;diffusealpha,0;zoomto,6,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y),
		CytusSpawnMessageCommand= cmd(linear,1;diffusealpha,1),
		CytusEndMessageCommand= cmd(linear,1;diffusealpha,0)
	},
	Def.Sprite{
		InitCommand=
			function(self)
				self:Load(songName .. "/lua/overlay.png")
			end,
		OnCommand= cmd(diffusealpha,0;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y),
		CytusSpawnMessageCommand= cmd(linear,1;diffusealpha,1),
		CytusEndMessageCommand= cmd(linear,1;diffusealpha,0)
	},
	Def.Sprite{
		InitCommand=
			function(self)
				self:Load(songName .. "/lua/bar.png")
			end,
		OnCommand= cmd(diffusealpha,0;zoomtowidth,SCREEN_WIDTH*0.5;x,SCREEN_WIDTH*0.25;y,SCREEN_CENTER_Y-125),
		CytusSpawnMessageCommand= cmd(linear,1;diffusealpha,1),
		CytusBeginMessageCommand=
			cmd(
			sleep,0;y,SCREEN_CENTER_Y-125;linear,8*(60/195);y,SCREEN_CENTER_Y+190;
			sleep,0;y,SCREEN_CENTER_Y+145;linear,8*(60/195);y,SCREEN_CENTER_Y-170;
			sleep,0;y,SCREEN_CENTER_Y-125;linear,8*(60/195);y,SCREEN_CENTER_Y+190;
			sleep,0;y,SCREEN_CENTER_Y+145;linear,8*(60/195);y,SCREEN_CENTER_Y-170;
			sleep,0;y,SCREEN_CENTER_Y-125;linear,8*(60/195);y,SCREEN_CENTER_Y+190;
			sleep,0;y,SCREEN_CENTER_Y+145;linear,8*(60/195);y,SCREEN_CENTER_Y-170;
			sleep,0;y,SCREEN_CENTER_Y-125;linear,8*(60/195);y,SCREEN_CENTER_Y+190;
			sleep,0;y,SCREEN_CENTER_Y+145;linear,8*(60/195);y,SCREEN_CENTER_Y-170),
		CytusEndMessageCommand= cmd(linear,1;diffusealpha,0)
	},
	Def.Sprite{
		InitCommand=
			function(self)
				self:Load(songName .. "/lua/bar.png")
			end,
		OnCommand= cmd(diffusealpha,0;zoomtowidth,SCREEN_WIDTH*0.5;x,SCREEN_WIDTH*0.75;y,SCREEN_CENTER_Y-125),
		CytusSpawnMessageCommand= cmd(linear,1;diffusealpha,1),
		CytusBeginMessageCommand=
			cmd(
			sleep,0;y,SCREEN_CENTER_Y-125;linear,8*(60/195);y,SCREEN_CENTER_Y+190;
			sleep,0;y,SCREEN_CENTER_Y+145;linear,8*(60/195);y,SCREEN_CENTER_Y-170;
			sleep,0;y,SCREEN_CENTER_Y-125;linear,8*(60/195);y,SCREEN_CENTER_Y+190;
			sleep,0;y,SCREEN_CENTER_Y+145;linear,8*(60/195);y,SCREEN_CENTER_Y-170;
			sleep,0;y,SCREEN_CENTER_Y-125;linear,8*(60/195);y,SCREEN_CENTER_Y+190;
			sleep,0;y,SCREEN_CENTER_Y+145;linear,8*(60/195);y,SCREEN_CENTER_Y-170;
			sleep,0;y,SCREEN_CENTER_Y-125;linear,8*(60/195);y,SCREEN_CENTER_Y+190;
			sleep,0;y,SCREEN_CENTER_Y+145;linear,8*(60/195);y,SCREEN_CENTER_Y-170),
		CytusEndMessageCommand= cmd(linear,1;diffusealpha,0)
	}
}